#! /bin/csh -f
#**********************************************************************
#  This Program is the Confidential and Proprietary product of Altera 
#  Corporation.
#  Any unauthorized use,  reproduction or transfer of this program is 
#  strictly prohibited. 
#  Copyright (c)  1995  by Altera Corp. All Rights Reserved.
#
#  Author: Kim Nguyen
#  Date: 10/02/95
#   
#**********************************************************************
echo " "
echo "$0 - Version 1.0 October 2, 1995"
echo " "
#
# Perform argument checking:  
#   The full path to the package.dat file should be provided
#   as argument $1 and this file must exist.  If it is not
#   provided, assume that it is "./package.dat".
#
if ($#argv < 1) then
	echo " "
	echo "Usage: hexprop2str.csh infile outfile"
	echo "       default outfile is syn.verilog"
	echo " "
	exit 1
else if ($#argv < 2) then
    set VlogFile = $1
	set VlogFileOut = "syn.verilog"
else
    set VlogFile = $1
    set VlogFileOut = $2
endif
if (! -e ${VlogFile}) then
     echo "Error: Source verilog file does not exist - ${VlogFile}"
     echo "       Script $0 terminated.
     echo " "
     exit 1
endif

#
# Generate ascii mapping file - ascii_map
#
echo '41  A '		> ascii_map
echo '42  B '		>> ascii_map
echo '43  C '		>> ascii_map
echo '44  D '		>> ascii_map
echo '45  E '		>> ascii_map
echo '46  F '		>> ascii_map
echo '47  G '		>> ascii_map
echo '48  H '		>> ascii_map
echo '49  I '		>> ascii_map
echo '4a  J '		>> ascii_map
echo '4b  K '		>> ascii_map
echo '4c  L '		>> ascii_map
echo '4d  M '		>> ascii_map
echo '4e  N '		>> ascii_map
echo '4f  O '		>> ascii_map
echo '50  P '		>> ascii_map
echo '51  Q '		>> ascii_map
echo '52  R '		>> ascii_map
echo '53  S '		>> ascii_map
echo '54  T '		>> ascii_map
echo '55  U '		>> ascii_map
echo '56  V '		>> ascii_map
echo '57  W '		>> ascii_map
echo '58  X '		>> ascii_map
echo '59  Y '		>> ascii_map
echo '5a  Z '		>> ascii_map
echo '5b  [ '		>> ascii_map
echo '5c  \ '		>> ascii_map
echo '5d  ] '		>> ascii_map
echo '5e  ^ '		>> ascii_map
echo '5f  _ '		>> ascii_map
echo '60  ` '		>> ascii_map
echo '61  a '		>> ascii_map
echo '62  b '		>> ascii_map
echo '63  c '		>> ascii_map
echo '64  d '		>> ascii_map
echo '65  e '		>> ascii_map
echo '66  f '		>> ascii_map
echo '67  g '		>> ascii_map
echo '68  h '		>> ascii_map
echo '69  i '		>> ascii_map
echo '6a  j '		>> ascii_map
echo '6b  k '		>> ascii_map
echo '6c  l '		>> ascii_map
echo '6d  m '		>> ascii_map
echo '6e  n '		>> ascii_map
echo '6f  o '		>> ascii_map
echo '70  p '		>> ascii_map
echo '71  q '		>> ascii_map
echo '72  r '		>> ascii_map
echo '73  s '		>> ascii_map
echo '74  t '		>> ascii_map
echo '75  u '		>> ascii_map
echo '76  v '		>> ascii_map
echo '77  w '		>> ascii_map
echo '78  x '		>> ascii_map
echo '79  y '		>> ascii_map
echo '7a  z '		>> ascii_map
echo '7b  { '		>> ascii_map
# [A.., a..z] is placed at the beginning of array to be found early
echo 27  \'		>> ascii_map
echo '28  ( '		>> ascii_map
echo '29  ) '		>> ascii_map
echo '2a  * '		>> ascii_map
echo '2b  + '		>> ascii_map
echo '2c  , '		>> ascii_map
echo '2d  - '		>> ascii_map
echo '2e  . '		>> ascii_map
echo '2f  / '		>> ascii_map
echo '30  0 '		>> ascii_map
echo '31  1 '		>> ascii_map
echo '32  2 '		>> ascii_map
echo '33  3 '		>> ascii_map
echo '34  4 '		>> ascii_map
echo '35  5 '		>> ascii_map
echo '36  6 '		>> ascii_map
echo '37  7 '		>> ascii_map
echo '38  8 '		>> ascii_map
echo '39  9 '		>> ascii_map
echo '3a  : '		>> ascii_map
echo '3b  ; '		>> ascii_map
echo '3c  < '		>> ascii_map
echo '3d  = '		>> ascii_map
echo '3e  > '		>> ascii_map
echo '3f  ? '		>> ascii_map
echo '40  @ '		>> ascii_map
echo '7c  '			>> ascii_map
echo '7e  ~ '		>> ascii_map
echo '7f DEL'		>> ascii_map

# The below entries is not likely used in the string property
echo '00 NUL'		>> ascii_map
echo '01 SOH'		>> ascii_map
echo '02 STX'		>> ascii_map
echo '03 ETX'		>> ascii_map
echo '04 EOT'		>> ascii_map
echo '05 ENQ'		>> ascii_map
echo '06 ACK'		>> ascii_map
echo '07 BEL'		>> ascii_map
echo '08 BS '		>> ascii_map
echo '09 HT '		>> ascii_map
echo '0a NL '		>> ascii_map
echo '0b VT '		>> ascii_map
echo '0c NP '		>> ascii_map
echo '0d CR '		>> ascii_map
echo '0e SO '		>> ascii_map
echo '0f SI '		>> ascii_map
echo '10 DLE'		>> ascii_map
echo '11 DC1'		>> ascii_map
echo '12 DC2'		>> ascii_map
echo '13 DC3'		>> ascii_map
echo '14 DC4'		>> ascii_map
echo '15 NAK'		>> ascii_map
echo '16 SYN'		>> ascii_map
echo '17 ETB'		>> ascii_map
echo '18 CAN'		>> ascii_map
echo '19 EM '		>> ascii_map
echo '1a SUB'		>> ascii_map
echo '1b ESC'		>> ascii_map
echo '1c FS '		>> ascii_map
echo '1d GS '		>> ascii_map
echo '1e RS '		>> ascii_map
echo '1f US '		>> ascii_map
echo '20 SP '		>> ascii_map
echo '21  ! '		>> ascii_map
echo '22  " '		>> ascii_map
echo '23  # '		>> ascii_map
echo '24  $ '		>> ascii_map
echo '25  % '		>> ascii_map
echo '26  & '		>> ascii_map

#
# Generate string property list - propstrs
#
#
echo 'latency'      >> propstrs
echo 'lpm_addr_control'     >> propstrs
echo 'lpm_direction'        >> propstrs
echo 'lpm_file'     >> propstrs
echo 'lpm_indata'       >> propstrs
echo 'lpm_outdata'      >> propstrs
echo 'lpm_rep'      >> propstrs
echo 'lpm_shifttype'        >> propstrs
echo 'lpm_type'     >> propstrs
echo 'polar_aclr'		>> propstrs
echo 'polar_aconst'		>> propstrs
echo 'polar_add_sub'		>> propstrs
echo 'polar_address'		>> propstrs
echo 'polar_addressa'		>> propstrs
echo 'polar_addressb'		>> propstrs
echo 'polar_aeb'		>> propstrs
echo 'polar_agb'		>> propstrs
echo 'polar_ageb'		>> propstrs
echo 'polar_alb'		>> propstrs
echo 'polar_aleb'		>> propstrs
echo 'polar_aload'		>> propstrs
echo 'polar_aneb'		>> propstrs
echo 'polar_aset'		>> propstrs
echo 'polar_busy'		>> propstrs
echo 'polar_cin'		>> propstrs
echo 'polar_clk_en'		>> propstrs
echo 'polar_clock'		>> propstrs
echo 'polar_clockx2'		>> propstrs
echo 'polar_clr'		>> propstrs
echo 'polar_cnt_en'		>> propstrs
echo 'polar_cout'		>> propstrs
echo 'polar_data'		>> propstrs
echo 'polar_data0x'		>> propstrs
echo 'polar_data1x'		>> propstrs
echo 'polar_data2x'		>> propstrs
echo 'polar_data3x'		>> propstrs
echo 'polar_data4x'		>> propstrs
echo 'polar_data5x'		>> propstrs
echo 'polar_data6x'		>> propstrs
echo 'polar_data7x'		>> propstrs
echo 'polar_dataa'		>> propstrs
echo 'polar_datab'		>> propstrs
echo 'polar_direction'		>> propstrs
echo 'polar_distance'		>> propstrs
echo 'polar_empty'		>> propstrs
echo 'polar_enable'		>> propstrs
echo 'polar_enabledt'		>> propstrs
echo 'polar_enabletr'		>> propstrs
echo 'polar_eq'		>> propstrs
echo 'polar_full'		>> propstrs
echo 'polar_gate'		>> propstrs
echo 'polar_inclock'		>> propstrs
echo 'polar_memenab'		>> propstrs
echo 'polar_outclock'		>> propstrs
echo 'polar_outenab'		>> propstrs
echo 'polar_overflow'		>> propstrs
echo 'polar_q'		>> propstrs
echo 'polar_qa'		>> propstrs
echo 'polar_qb'		>> propstrs
echo 'polar_result'		>> propstrs
echo 'polar_rreq'		>> propstrs
echo 'polar_sclr'		>> propstrs
echo 'polar_sconst'		>> propstrs
echo 'polar_sel'		>> propstrs
echo 'polar_shiften'		>> propstrs
echo 'polar_shiftin'		>> propstrs
echo 'polar_shiftout'		>> propstrs
echo 'polar_sload'		>> propstrs
echo 'polar_sset'		>> propstrs
echo 'polar_sum'		>> propstrs
echo 'polar_threshlevel='		>> propstrs
echo 'polar_threshold'		>> propstrs
echo 'polar_tridata'		>> propstrs
echo 'polar_underflow'		>> propstrs
echo 'polar_updown'		>> propstrs
echo 'polar_we'		>> propstrs
echo 'polar_wea'		>> propstrs
echo 'polar_web'		>> propstrs
echo 'polar_wreq'		>> propstrs
# Generate the awk script to convert the hex values of the above
# string properties to string value - hexprop2str.awk
#
echo 'BEGIN {	'> hexprop2str.awk
echo '    ascii_file = "ascii_map"'>> hexprop2str.awk
echo '    prop_file = "propstrs"'>> hexprop2str.awk
echo '    ascii_max_entry = 0;'>> hexprop2str.awk
echo '    prop_max_entry = 0;'>> hexprop2str.awk
echo '    found = 0;'>> hexprop2str.awk
echo '    prop = 0;'>> hexprop2str.awk
echo '}'>> hexprop2str.awk
echo ''>> hexprop2str.awk
echo '# This is the main program'>> hexprop2str.awk
echo '{'>> hexprop2str.awk
echo '    # get ascii mappings'>> hexprop2str.awk
echo '    if((FILENAME == ascii_file) && (NF == 2) && !($0 ~ /^#/))'>> hexprop2str.awk
echo '    {'>> hexprop2str.awk
echo '        ascii_tb[++ascii_max_entry] = $0;'>> hexprop2str.awk
echo '    }'>> hexprop2str.awk
echo '    # get ascii mappings'>> hexprop2str.awk
echo '    else if((FILENAME == prop_file)&&(NF == 1)&&!($0 ~ /^#/))'>> hexprop2str.awk
echo '    {'>> hexprop2str.awk
echo '        prop_names[++prop_max_entry] = $0;'>> hexprop2str.awk
echo '    }'>> hexprop2str.awk
echo '    else if((FILENAME != ascii_file)&&(ascii_max_entry > 0)&&(prop_max_entry > 0))'>> hexprop2str.awk
echo '    {'>> hexprop2str.awk
echo '        #-------------------------------------------------------'>> hexprop2str.awk
echo '        # after the ascii table is read, perform the conversion '>> hexprop2str.awk
echo '        # on parameter whose name is on the str_props list.'>> hexprop2str.awk
echo '        #------------------------------------------------------'>> hexprop2str.awk
echo '        if($1 == "parameter")'>> hexprop2str.awk
echo '        {'>> hexprop2str.awk
echo '            prop = 1;'>> hexprop2str.awk
echo '            print $0 ;'>> hexprop2str.awk
echo '            next;'>> hexprop2str.awk
echo '        }'>> hexprop2str.awk
echo '        if (prop == 1)'>> hexprop2str.awk
echo '        {'>> hexprop2str.awk
echo '            for(j = 1; j <= prop_max_entry; j = j + 1)'>> hexprop2str.awk
echo '            {'>> hexprop2str.awk
echo '                if($1 == prop_names[j])'>> hexprop2str.awk
echo '                {'>> hexprop2str.awk
echo '                    found = 1;'>> hexprop2str.awk
echo '                }'>> hexprop2str.awk
echo '            }'>> hexprop2str.awk
echo '            if(found)'>> hexprop2str.awk
echo '            {	'>> hexprop2str.awk
echo '                str_val = "";'>> hexprop2str.awk
echo -n '                '>> hexprop2str.awk
echo -n 'hex_val = substr($3, index($3, "'>> hexprop2str.awk
echo -n \'>> hexprop2str.awk
echo 'h")+2, length($3));'>> hexprop2str.awk
echo '                for (idx = 1; idx < length(hex_val); idx =idx+2)'>> hexprop2str.awk
echo '                {'>> hexprop2str.awk
echo '                    ahex = substr(hex_val, idx, 2);'>> hexprop2str.awk
echo '                    # rename the illegal pinname'>> hexprop2str.awk
echo '                    for(i = 1; i <= ascii_max_entry; i++)'>> hexprop2str.awk
echo '                    {'>> hexprop2str.awk
echo '                        split(ascii_tb[i], names);'>> hexprop2str.awk
echo '                        if (ahex == names[1])'>> hexprop2str.awk
echo '                        {'>> hexprop2str.awk
echo '                            str_val = sprintf("%s%s", str_val, names[2]);'>> hexprop2str.awk
echo '                        }'>> hexprop2str.awk
echo '                    }'>> hexprop2str.awk
echo '                }'>> hexprop2str.awk
echo '                print "\t\t" $1, $2, "\"" str_val "\";"  ;'>> hexprop2str.awk
echo '                found = 0;'>> hexprop2str.awk
echo '            }'>> hexprop2str.awk
echo '            else'>> hexprop2str.awk
echo '            {'>> hexprop2str.awk
echo '                print $0 ;'>> hexprop2str.awk
echo '            }'>> hexprop2str.awk
echo '            prop = 0;'>> hexprop2str.awk
echo '        }'>> hexprop2str.awk
echo '        else'>> hexprop2str.awk
echo '        {'>> hexprop2str.awk
echo '            print $0 ;'>> hexprop2str.awk
echo '        }'>> hexprop2str.awk
echo '    }'>> hexprop2str.awk
echo '}'>> hexprop2str.awk

#
# run the awk program to convert string property.
#
awk -f hexprop2str.awk ascii_map propstrs ${VlogFile} > ${VlogFileOut}

#
# Clean up
#
rm ascii_map
rm propstrs
rm hexprop2str.awk

exit 0
